<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON TM-U950 Slip CCF");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Nota de Credito Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,85);

	$fecha = explode("-",$fecha);
	$fechadia = explode(" ",$fecha[2]);
	$phpPrinter->printString($fechadia[0],2,$printer,$acum,13,11,560);
	$phpPrinter->printString($fecha[1],2,$printer,$acum,13,0,610);
	$phpPrinter->printString($fecha[0],2,$printer,$acum,13,0,660);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($cliente,0,35))),2,$printer,$acum,13,11,160);
	$phpPrinter->tabPrinter($acum,10);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,20))),2,$printer,$acum,13,11,160);
	$phpPrinter->tabPrinter($acum,15);
	//$phpPrinter->printString(strtoupper(utf8_decode(substr($vendedor[0]->nombre_usuario,0,10))),2,$printer,$acum,13,0,585);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($nrc_cliente,0,20))),2,$printer,$acum,13,11,500);
	$phpPrinter->tabPrinter($acum,25);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($doc_anulado_serie." ".$doc_anulado_numero,0,20))),2,$printer,$acum,13,11,500);
	$phpPrinter->tabPrinter($acum,25);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString($producto->cant,2,$printer,$acum,9,7,60);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),33),2,$printer,$acum,9,0,160);
		$phpPrinter->printString($producto->costo,2,$printer,$acum,9,0,560);
		$phpPrinter->printString($producto->cant * $producto->costo,2,$printer,$acum,9,0,700);
		$phpPrinter->tabPrinter($acum,5);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 100, 460);
	printer_draw_text($printer,"Ref:".$referencia, 400, 460);
	printer_draw_text($printer,$totales['totalGrabadas'], 700, 460);
	printer_draw_text($printer,$totales['totalIVA'], 700, 475);
	printer_draw_text($printer,$totales['totalIVA'] + $totales['totalGrabadas'], 700, 490);
	printer_draw_text($printer,$totales['totalExento'], 700, 515);
	printer_draw_text($printer,$totales['totalNS'], 700, 530);
	printer_draw_text($printer,$totales['totalTotal'], 700, 540);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>